/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Unit;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

public class CTMPackReloadListener
extends SimplePreparableReloadListener<Unit> {
    private static final Map<IRegistryDelegate<Block>, Predicate<RenderType>> blockRenderChecks = Maps.newHashMap();
    private static final Field _blockRenderChecks = ObfuscationReflectionHelper.findField(ItemBlockRenderTypes.class, (String)"blockRenderChecks");
    private static final MethodHandle _fancyGraphics;

    @SubscribeEvent
    public void onParticleFactoryRegister(ParticleFactoryRegisterEvent event) {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
    }

    protected Unit prepare(ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        return Unit.INSTANCE;
    }

    protected void apply(Unit objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ResourceUtil.invalidateCaches();
        TextureMetadataHandler.INSTANCE.invalidateCaches();
        AbstractCTMBakedModel.invalidateCaches();
        this.refreshLayerHacks();
    }

    private void refreshLayerHacks() {
        blockRenderChecks.forEach((b, p) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (Predicate)p));
        blockRenderChecks.clear();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            BlockState state = block.m_49966_();
            Predicate<RenderType> predicate = this.getLayerCheck(state, Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state));
            if (predicate == null) continue;
            blockRenderChecks.put((IRegistryDelegate<Block>)block.delegate, this.getExistingRenderCheck(block));
            ItemBlockRenderTypes.setRenderLayer((Block)block, predicate);
        }
    }

    @Nullable
    private Predicate<RenderType> getLayerCheck(BlockState state, BakedModel model) {
        if (model instanceof AbstractCTMBakedModel) {
            AbstractCTMBakedModel ctmModel = (AbstractCTMBakedModel)model;
            return layer -> ctmModel.getModel().canRenderInLayer(state, (RenderType)layer);
        }
        if (model instanceof WeightedBakedModel) {
            WeightedBakedModel weightedModel = (WeightedBakedModel)model;
            return CachingLayerCheck.of(state, weightedModel.f_119541_, wm -> (BakedModel)wm.m_146310_());
        }
        if (model instanceof MultiPartBakedModel) {
            MultiPartBakedModel multiPartModel = (MultiPartBakedModel)model;
            return CachingLayerCheck.of(state, multiPartModel.f_119459_, Pair::getRight);
        }
        return null;
    }

    private Predicate<RenderType> getExistingRenderCheck(Block block) {
        try {
            return (Predicate)((Map)_blockRenderChecks.get(null)).get(block.delegate);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canRenderInLayerFallback(BlockState state, RenderType type) {
        Block block = state.m_60734_();
        if (block instanceof LeavesBlock) {
            try {
                return _fancyGraphics.invokeExact() ? type == RenderType.m_110457_() : type == RenderType.m_110451_();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        Class<ItemBlockRenderTypes> clazz = ItemBlockRenderTypes.class;
        synchronized (ItemBlockRenderTypes.class) {
            Predicate<RenderType> rendertype = blockRenderChecks.get(block.delegate);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return rendertype != null ? rendertype.test(type) : type == RenderType.m_110451_();
        }
    }

    static {
        try {
            _fancyGraphics = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(ItemBlockRenderTypes.class, (String)"f_109277_"));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CachingLayerCheck
    implements Predicate<RenderType> {
        private final BlockState state;
        private final List<AbstractCTMBakedModel> models;
        private final boolean useFallback;
        private final Object2BooleanMap<RenderType> cache = new Object2BooleanOpenHashMap();

        static <T> CachingLayerCheck of(BlockState state, Collection<T> rawModels, Function<T, BakedModel> converter) {
            List<AbstractCTMBakedModel> ctmModels;
            return new CachingLayerCheck(state, ctmModels, (ctmModels = rawModels.stream().map(converter).filter(m -> m instanceof AbstractCTMBakedModel).map(m -> (AbstractCTMBakedModel)m).toList()).size() < rawModels.size());
        }

        @Override
        public boolean test(@Nullable RenderType layer) {
            return this.cache.computeIfAbsent((Object)layer, type -> this.models.stream().anyMatch(m -> m.getModel().canRenderInLayer(this.state, (RenderType)type)) || this.useFallback && CTMPackReloadListener.canRenderInLayerFallback(this.state, type));
        }

        public CachingLayerCheck(BlockState state, List<AbstractCTMBakedModel> models, boolean useFallback) {
            this.state = state;
            this.models = models;
            this.useFallback = useFallback;
        }
    }
}

